/*
 * Userspace program that communicates with the vga device driver
 * primarily through ioctls
 *
 * Source Code:
 *
 * Stephen A. Edwards
 * Columbia University
 *
 * Modified by:
 *
 * Gautham Vunnam
 * Columbia University
 */

#include <stdio.h>
#include <unistd.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include "mat_operations.h"
#include "data.h"	

int vga_led_fd;  // vga_led file descriptor

int main(int argc, char *argv[]) {
	

  vga_led_arg_t vla;
  int i, j=0, facenumber = 0,k;
	char color = 1;
  static const char filename[] = "/dev/vga_led";
  unsigned int coords[12];
  unsigned int z;

	// matrix objects

	float xw, yw, zw;

	float adjusted_vertices[62][4];
	float adjusted_vertex[4][1];
	float vertex[4][1];
	float rotation[4][4];
	float transform[4][4];
	float temp[4][4];
	float world[4][4];
	float temp41[4][1];

	float pixels[62][3];
	int pixellist[1080];

	getRotationMatrix(-atoi(argv[1]), -atoi(argv[2]), 180, rotation);

	dotProduct44(TRANSLATE, rotation, temp);
	dotProduct44(temp, SCALE, world);
	dotProduct44(PROJECTION, VIEW, temp);
	dotProduct44(temp, world, transform);


	for(i = 0; i < 62; i++)
	{
		for(j = 0; j < 4; j++)
		{
			vertex[j][0] = vertices[i][j];
		}	

		dotProduct41(transform, vertex, adjusted_vertex);
		
		scaleMat41(adjusted_vertex, 1/adjusted_vertex[3][0], temp41);

		xw = ((640 / 2.0) * temp41[0][0]) + (0 + (640 / 2.0));
		yw = ((480 / 2.0) * temp41[1][0]) + (0 + (480 / 2.0));
		zw = ((9) / 2.0) * temp41[2][0] + ((11) / 2.0);

		pixels[i][0] = xw;
		pixels[i][1] = yw;
		pixels[i][2] = zw;

	}	

	for(i = 0; i < 120; i++)
	{
		pixellist[i*9] = (int) pixels[faces[i][0]][0]*32;
		pixellist[i*9 + 1] = (int) pixels[faces[i][0]][1]*32;
		pixellist[i*9 + 2] = (int) pixels[faces[i][0]][2]*32;
		pixellist[i*9 + 3] = (int) pixels[faces[i][1]][0]*32;
		pixellist[i*9 + 4] = (int) pixels[faces[i][1]][1]*32;
		pixellist[i*9 + 5] = (int) pixels[faces[i][1]][2]*32;
		pixellist[i*9 + 6] = (int) pixels[faces[i][2]][0]*32;
		pixellist[i*9 + 7] = (int) pixels[faces[i][2]][1]*32;			
		pixellist[i*9 + 8] = (int) pixels[faces[i][2]][2]*32;
    }
	

  /* just open vga driver like it's a file
     using the file descriptor specified earlier */
  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

		if((atoi(argv[3]) != 1) && (atoi(argv[4]) == 1))
		{
		for (i = 0; i<1080; i += 9) {

			coords[0] = pixellist[i];
			coords[1] = pixellist[i+1];
			coords[2] = pixellist[i+2];	
			coords[3] = pixellist[i+3];
			coords[4] = pixellist[i+4];
			coords[5] = pixellist[i+5];
			coords[6] = pixellist[i+6];
			coords[7] = pixellist[i+7];
			coords[8] = pixellist[i+8];

			if (facenumber < 40) {
				color = 3;
			}

			else if (facenumber >= 40 && facenumber < 79) {
				color = 2;
			}

			else {
				color = 1;
			} 
			
			coords[10] = 0;			
				
			// first time around send a color and write screen
			coords[9] = 0;  // send plate color
			coords[11] = 1;  // clear the screen

			if (facenumber == 119) {
				coords[10] = 0; // show screen
			}
			else {
				coords[10] = 1; // hide screen
			}

			write_coordinates(coords);
			
			facenumber++;
		 	usleep(1000);	
    }

    }
	 if(atoi(argv[4]) != 1)
{
 		 for (i = 0; i<1080; i += 9) {

			coords[0] = pixellist[i];
			coords[1] = pixellist[i+1];
			coords[2] = pixellist[i+2];	
			coords[3] = pixellist[i+3];
			coords[4] = pixellist[i+4];
			coords[5] = pixellist[i+5];
			coords[6] = pixellist[i+6];
			coords[7] = pixellist[i+7];
			coords[8] = pixellist[i+8];

			if (facenumber < 40) {
				color = 3;
			}

			else if (facenumber >= 40 && facenumber < 79) {
				color = 2;
			}

			else {
				color = 1;
			} 
			
			coords[10] = 0;			

			if (facenumber == 119) {
				coords[10] = 0; // show screen
			}
			else {
				coords[10] = 1; // hide screen
			}
			
				
			// first time around send a color and write screen
			coords[9] = color;  // send plate color
			coords[11] = 0;  // don't clear the screen

			write_coordinates(coords);
			
			facenumber++;
		 	usleep(1000);	
    }
    }
		usleep(2000);  // wait 10 sec for the screen to clear	
		
		if(atoi(argv[3]) != 1)
		{
		for (i = 0; i<1080; i += 9) {

			coords[0] = pixellist[i];
			coords[1] = pixellist[i+1];
			coords[2] = pixellist[i+2];	
			coords[3] = pixellist[i+3];
			coords[4] = pixellist[i+4];
			coords[5] = pixellist[i+5];
			coords[6] = pixellist[i+6];
			coords[7] = pixellist[i+7];
			coords[8] = pixellist[i+8];     

			if (facenumber < 40) {
				color = 3;
			}

			else if (facenumber >= 40 && facenumber < 79) {
				color = 2;
			}

			else {
				color = 1;
			} 
			
			coords[10] = 0;			
				
			// first time around send a color and write screen
			coords[9] = 0;  // send plate color
			coords[11] = 1;  // don't clear the screen

			if (facenumber == 119) {
				coords[10] = 0; // show screen
			}
			else {
				coords[10] = 1; // hide screen
			}

			write_coordinates(coords);
			
			facenumber++;
		 	usleep(1000);	
    }

    }

  return 0;

}





